<?php

namespace HelloNico\Twig;

use Twig\Compiler;
use Twig\Node\Node;

/**
 * @author Julien Galenski <julien.galenski@gmail.com>
 */
class DumpNode extends Node
{
    private $varPrefix;

    public function __construct($varPrefix, Node $values = null, $lineno, $tag = null)
    {
        $nodes = array();
        if (null !== $values) {
            $nodes['values'] = $values;
        }

        parent::__construct($nodes, array(), $lineno, $tag);
        $this->varPrefix = $varPrefix;
    }

    /**
     * {@inheritdoc}
     */
    public function compile(Compiler $compiler)
    {
        $compiler
            ->write("if (\$this->env->isDebug()) {\n")
            ->indent();

        if (!$this->hasNode('values')) {
            // remove embedded templates (macros) from the context
            $compiler
                ->write(sprintf('$%svars = array();'."\n", $this->varPrefix))
                ->write(sprintf('foreach ($context as $%1$skey => $%1$sval) {'."\n", $this->varPrefix))
                ->indent()
                ->write(sprintf('if (!$%sval instanceof \Twig\Template) {'."\n", $this->varPrefix))
                ->indent()
                ->write(sprintf('$%1$svars[$%1$skey] = $%1$sval;'."\n", $this->varPrefix))
                ->outdent()
                ->write("}\n")
                ->outdent()
                ->write("}\n")
                ->addDebugInfo($this)
                ->write(sprintf('\Symfony\Component\VarDumper\VarDumper::dump($%svars);'."\n", $this->varPrefix));
        } elseif (($values = $this->getNode('values')) && 1 === $values->count()) {
            $compiler
                ->addDebugInfo($this)
                ->write('\Symfony\Component\VarDumper\VarDumper::dump(')
                ->subcompile($values->getNode(0))
                ->raw(");\n");
        } else {
            $compiler
                ->addDebugInfo($this)
                ->write('\Symfony\Component\VarDumper\VarDumper::dump(array('."\n")
                ->indent();
            foreach ($values as $node) {
                $compiler->write('');
                if ($node->hasAttribute('name')) {
                    $compiler
                        ->string($node->getAttribute('name'))
                        ->raw(' => ');
                }
                $compiler
                    ->subcompile($node)
                    ->raw(",\n");
            }
            $compiler
                ->outdent()
                ->write("));\n");
        }

        $compiler
            ->outdent()
            ->write("}\n");
    }
}
