<?php
/**
*
* Theme name: Yagami
*
* Description: Yagami is a framework which brings a real MVC approach in wordpress development.
*
* @author Kevin Vacherot <kevin.vacherot@adveris.fr>
* @version 1.0.0
*
*/

/*
* Errors handling
*/
error_reporting(E_ERROR | E_WARNING | E_PARSE);
ini_set("display_errors", 1);

/*
* Load helpers functions (nothing executed here)
*/
require 'App/config/_constants.php';

/**
* Load autoloader
*/
require_once 'App/Autoloader.php';

/**
* Register Autoloader
*/
\App\Autoloader::register();

/*
* Check if Timber is activated to proceed
*/
Services\NotificationsService::TimberControl(class_exists('Timber'));

/*
* Run Starer theme mechanisms if/after Timber is loaded
*/
class_exists('Timber') && \App\AppKernel::registerManagers();

// Add thumbs post / pages
add_filter('manage_posts_columns', 'posts_columns', 5);
add_action('manage_posts_custom_column', 'posts_custom_columns', 5, 2);
function posts_columns($defaults){
    $defaults['riv_post_thumbs'] = __('Miniatures');
    return $defaults;
}
function posts_custom_columns($column_name, $id){
    if($column_name === 'riv_post_thumbs'){
        echo the_post_thumbnail( array(80,80) );
    }
}