export default {
    init: (app, CookieManager, Swiper) => {
        /*
        |
        | Constants
        |-----------
        */
        const
            $body = $('body'),
            $cookieBanner = $('.cookie-banner'),
            $cookieClose = $cookieBanner.find('.item-close'),
            $cookieAccept = $cookieBanner.find('.item-accept'),
            $cookieRefuse = $cookieBanner.find('.item-refuse')
        ;


        /*
		|
		| Slider home
		|-----------------
		*/

        var swiper = new Swiper('#homeswiper.swiper-container', {
            slidesPerView: 1.5,
            loop: true,
            speed: 1000,
            autoplay:
                {
                    delay: 3000
                },
            grabCursor: true,
            centeredSlides: true,
            spaceBetween: 50,
            pagination: {
                el: '.swiper-pagination',
                clickable: true
            },
            navigation: {
                prevEl: '.swiper-btn-prev',
                nextEl: '.swiper-btn-next'
            },
            breakpoints: {
                992: {
                    slidesPerView: 1.5,
                    spaceBetween: 50,
                },
                767: {
                    slidesPerView: 1.5,
                    spaceBetween: 50,
                },
                480: {
                    slidesPerView: 1,
                    spaceBetween: 0,
                },
                0: {
                    slidesPerView: 1,
                    spaceBetween: 0,
                }
            }
        });


        /*
		|
		| Video home
		|-----------------
		*/
        jQuery(document).ready(function () {
            const player = new Plyr('#player-video');
        });

        /* Chiffres animates */
        const $chiffres = jQuery(".chiffres");
        if ($chiffres.length) {
            var a = 0;
            $(window).scroll(function () {
                var oTop = $('.chiffres').offset().top - window.innerHeight;
                if (a == 0 && $(window).scrollTop() > oTop) {
                    $('.chiffre span').each(function () {
                        var $this = $(this),
                            countTo = $this.attr('data-count');
                        $({
                            countNum: $this.text()
                        }).animate({
                                countNum: countTo
                            },
                            {
                                duration: 3500,
                                easing: 'swing',
                                step: function () {
                                    $this.text(Math.floor(this.countNum));
                                },
                                complete: function () {
                                    $this.text(this.countNum);
                                    //alert('finished');
                                }
                            });
                    });
                    a = 1;
                }
            });
        }

        /*
		|
		| Cookie Manager
		|-----------------
		*/
        new CookieManager($cookieBanner, {
            name: 'adveris_cookie_use',
            duration: 30,
            buttons: {
                accept: $cookieAccept,
                refuse: $cookieRefuse,
                close: $cookieClose
            },
            onAccept: () => {
                console.log('accpeted')
            },
            onRefuse: () => {
                console.log('refused')
            }
        });

        $body.on('loaderEnd', () => console.log('ended'))
    }
}